<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CLayouts extends CPlugin{
	
	var $tplvars; 
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $tpl_type = "global";
	

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		if ($_GET["mod"] == "layouts") {
			switch ($_GET["sub"]) {
			}
			
		}

	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"layout"				=> "layout.htm",

			"content"				=> "content.htm",

			"generic"				=> "generic.htm",
			"generic.footer"		=> "generic.footer.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

	} 

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($lid , $content , $lw = "" , $header = "" , $footer = "") {
		global $base, $_TSM , $_LANG_ID;

		$fields = "layout_fp_menu_show, layout_template,layout_fp,layout_fp_menu,layout_id, layout_device,layout_has_mobile,layout_has_tablet,layout_fp_menu_pos ";

		if (!STP_DISABLE_MODULE_LAYOUTS) {
			//load the selected layout
			if ($lid) {
				$layout = $this->db->QFetchArray("SELECT {$fields} FROM {$this->tables['core:layouts']} WHERE layout_id={$lid} ");			
			}				

			//if no layout then try to load the generic layout
			if (!is_array($layout)) {
				$layout = $this->db->QFetchArray(
					"SELECT {$fields} FROM {$this->tables['core:layouts']} WHERE layout_id=%d",
					array($this->vars->data["set_layout"])
				);			
			}		

		}


		//i have no generic layout so ... return a no column layout
		if (!is_array($layout)) {
			return "";
		} else {
			

			if ($layout["layout_has_mobile"] && $base->isPhone) {
				$cond = " AND layout_device=2 ";
			} elseif ($layout["layout_has_tablet"] && $base->isTablet) {
				$cond = " AND layout_device=1 ";
			} else {
				$cond = " AND layout_device=0";
			}
			
			//read the blocks
			$blocks = $this->db->QFetchRowArray("
				SELECT 
					*,l.layout_id as layout_id 
				FROM 
					{$this->tables['core:layouts']}  as l
				LEFT JOIN
					{$this->tables['core:layouts_lang']}  as lang
				ON
					l.layout_id = lang.layout_id AND
					lang.lang_id = %d
				WHERE 
					layout_parent = {$layout[layout_id]} AND 
					layout_status=1 {$cond} 
				ORDER BY 
					layout_order ASC
			" , array(
					$_LANG_ID
				)
			);
			

			//read all the ids
			if (!is_array($blocks)) {
				return "";
			}

			foreach ($blocks as $key => $val) {
				$ids[] = $val["layout_id"];
			}				


			$this->__init();

			//read all the widgets

			//read all the columns
			$widgets = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['core:layouts_items']} WHERE layitem_layout IN (" . implode("," , $ids) . ") ORDER BY layitem_layout,layitem_column,layitem_order ASC");

			//process the content of the widget

			if (is_array($widgets)) {
				foreach ($widgets as $key => $val) {

					switch ($val["layitem_widget"]) {
						case "-1":
						case "-2":
						break; 

						default:
							$wid[] = $val["layitem_widget"];
						break;
					}
				}

				if (is_array($wid)) {
					$wid = implode("," , $wid);					
				}
				
				if ($lw) {

					if ($wid) {
						$wid .= "," . $lw;
					} else {
						$wid = $lw;
					}
					
				}

				//read the widget information
				$widgets_data =  $this->module->plugins["widgets"]->Widgets(
					$wid,
					"array"
				);


				
				foreach ($widgets as $key => $val) {
					switch ($val["layitem_widget"]) {
						//current module content
						case "-1":
							//get the widget 
							$content_widget = $this->plugins["widgets"]->GetWidget(-1);
							if (is_array($content_widget) && $content_widget["widget_bg"]) {
								$bg = $this->plugins["backgrounds"]->GetBg($content_widget["widget_bg"]);
							}
							
							$data[$val["layitem_layout"]][$val["layitem_column"]] .= CtemplateStatic::Replace(
								$content,
								array(
									"mod_background_html"	=> $bg["html"],
									"mod_background_class"	=> $bg["class"],
								)
							);
						break;

						case "-2":

						break;

						default:

							if (is_Array($widgets_data[$val["layitem_widget"]])) {
								$data[$val["layitem_layout"]][$val["layitem_column"]] .= $widgets_data[$val["layitem_widget"]]["content"];
							}
							
						break;

					}
					
				}
			}

			//build the html with columns

			$template = &$this->private->templates["content"];


			foreach ($blocks as $kblock => $block) {

				$autoresize = "";


				$cols = "";
				
				for ($i = 1; $i<=$block["layout_columns"] ; $i++) {

					$class = array();						

					if ($block["layout_c" . $i . ""]) {
						$class[] = "col-xl-" . $block["layout_c" . $i];
					}

					if ($block["layout_c" . $i . "_lg"]) {
						$class[] = "col-lg-" . $block["layout_c" . $i . "_lg"];
					}

					if ($block["layout_c" . $i . "_md"]) {
						$class[] = "col-md-" . $block["layout_c" . $i . "_md"];
					}

					if ($block["layout_c" . $i . "_sm"]) {
						$class[] = "col-sm-" . $block["layout_c" . $i . "_sm"];
					}

					if ($block["layout_c" . $i . "_xs"]) {
						$class[] = "col-" . $block["layout_c" . $i . "_xs"];
					}


					//md fal back
					if (!$block["layout_c" . $i . "_lg"]) {
						$block["layout_c" . $i . "_lg"] = $block["layout_c" . $i];
					}						

					if ($block["layout_extra_css"] && $block["layout_css_" . $i]) {
						$class[] = $block["layout_css_" . $i];
					}
					
					$scheme = array();

					if ($block["layout_extra_bg"] && $block["layout_bg_" . $i]) {
						$bg = $this->plugins["backgrounds"]->GetBg($block["layout_bg_" . $i]);

						if ($bg["bg:scheme"]) {
							$scheme["bg:scheme"] = $bg["bg:scheme"];
						}						
					} else {
						$bg = array();
					}

					

					$cols .= $template->blockReplace(
						"Column",
						array(
							"content"			=> $data[$block["layout_id"]][$i],
							"class"				=> implode(" " , $class),
							"cnt"				=> $i,
							"background_class"	=> $bg["class"],
							"background_html"	=> $bg["html"],
						),
						$scheme
					);
					
				}


				if ($block["layout_bg_lib"]) {
					$bg = $this->plugins["backgrounds"]->GetBg($block["layout_bg_lib"]);

					if ($bg["bg:scheme"]) {
						$block["bg:scheme"] = $bg["bg:scheme"];
					}
					
				} else {
					$bg = array();
				}
				
				//clear backgrounds
				$block["bg_s_class"] = "";
				$block["bg_s_html"] = "";
				$block["bg_c_class"] = "";
				$block["bg_c_html"] = "";

				//if not parallax
				if ($block["layout_bg_style"]) {
					$block["bg_c_class"] = $bg["class"];
					$block["bg_c_html"] = $bg["html"];

				} else {
					$block["bg_s_class"] = $bg["class"];
					$block["bg_s_html"] = $bg["html"];
				}

				$block_html = $template->blockReplace(
					"Main",
					array(
						"style"			=> $template->blockReplace($block["layout_template"] == "fluid" ? "Fluid" : "Boxed"),
						"columns"		=> $cols,
					),
					$block
				);

				$style = "";
										
				switch ($block["layout_height"]) {
					case "1":
						$autoresize = " full-page";
					break;

					case "2":
						$autoresize = " half-page";
					break;

					case "4":
						$style = "min-height: " . $block["layout_height_custom"] . $block["layout_height_dim"];
					break;


				}


				if ($block["layout_bg_lib"]) {
					$autoresize .= " " . $block["layout_bg_margin_top"] . " " . $block["layout_bg_margin_bottom"] . " ";
				}
			

				switch ($block["layout_align"]) {
					case "0":  $autoresize .= " vertical-align-top"; break;
					case "1":  $autoresize .= " vertical-align-center"; break;
					case "2":  $autoresize .= " vertical-align-bottom"; break;
				}

				$attrs = array();

				if ($layout["layout_fp"] && ($layout["layout_template"] == "1")) {
					$this->plugins["skineditor"]->setBodyAttr("data-scroll-page" , "true");
				}

				if ($layout["layout_fp_menu"] && ($layout["layout_template"] == "1")) {

					$this->plugins["skineditor"]->setBodyAttr("data-scroll-menu" , $layout["layout_fp_menu"] ? "true" : "false");
					$this->plugins["skineditor"]->setBodyAttr("data-scroll-menu-pos" , $layout["layout_fp_menu_pos"] ? "right" : "left");
					$this->plugins["skineditor"]->setBodyAttr("data-scroll-menu-allways" , $layout["layout_fp_menu_show"] ? "true" : "false");
	
					$attrs[] = "data-scroll-menu=\"{$block[layout_menu]}\"";
					$attrs[] = "data-scroll-menu-anchor=\"{$block[layout_menu_url]}\"";

				}
				


				$final_html .= $this->_t("content")->blockReplace(
				"Section" , 
					array(
						"content"		=> $block_html,
						"inverted"		=> $inverted,
						"autoresize"	=> $autoresize,
						"section_style" => $style,
						"layout_attr"	=> implode(" " , $attrs)
					),
					$block
				);			
			}

			
			
					

			return $final_html;

		}		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function footerLayout() {

		global $_SESS , $_TSM;


		$module = $this->plugins["globalhooks"]->module_data;


		//detect the footer layout from current module
		if ($module["settings"]["set_layout_footer"]) {
			//detect the default footer
			$layout = $module["settings"]["set_layout_footer"];
		}


		//generic layouts
		if (!$layout) {
			//detect module status
			if ($module["mod_protected"] || $module["module_protected"]) {
				$layout = $this->vars->data["set_layout_footer_protected"];				
			} else {			
				$layout = $this->vars->data["set_layout_footer"];
			}
		}


		//render footer layout
		if ($layout) {


			return array(
				"_content"		=> $this->Render($layout, ""),
				"_copyright"	=> $this->plugins["skineditor"]->CopyrightBar($layout),
			);
		} else {
			//clean footer variable
			return array(
				"_content"		=> "",
				"_copyright"	=> "",
			);
		}
	}

	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function detect($default , $protected = false) {
		global $_SESS;

		//in future i should add some caching to save an extra check.
		if ($default) {

			//check if layout exists or was deleted
			$layout = $this->db->QFetchArray("SELECT * FROM {$this->tables['core:layouts']} WHERE layout_id={$default} ");			

			if (is_array($layout)) {
				return $default;
			}
			
		}

		if ($protected ) {
			return $this->vars->data["set_layout_protected"];
		} else {
			return $this->vars->data["set_layout"];
		}
			
	}

	

	function hex2rgb($hex) {
	   $hex = str_replace("#", "", $hex);

	   if(strlen($hex) == 3) {
		  $r = hexdec(substr($hex,0,1).substr($hex,0,1));
		  $g = hexdec(substr($hex,1,1).substr($hex,1,1));
		  $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
		  $r = hexdec(substr($hex,0,2));
		  $g = hexdec(substr($hex,2,2));
		  $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = array("r"	=> $r, "g"	=> $g, "b"	=> $b);
	   //return implode(",", $rgb); // returns the rgb values separated by commas

	   return $rgb; // returns an array with the rgb values
	}
}

?>